<?php
/**
 * メインダッシュボード
 * noteクリエイター向けダッシュボード
 */

require_once __DIR__ . '/includes/auth.php';

// 認証チェック - 未ログインの場合はログインページへリダイレクト
requireLogin('login.php');

$currentUser = getCurrentUser();
$csrfToken = generateCsrfToken();
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>noteクリエイターダッシュボード</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <header class="header">
        <div class="header-container">
            <h1 class="header-title">noteクリエイターダッシュボード</h1>
            <div class="header-user">
                <span class="user-name"><?php echo htmlspecialchars($currentUser['username'], ENT_QUOTES, 'UTF-8'); ?></span>
                <a href="logout.php" class="btn btn-logout">ログアウト</a>
            </div>
        </div>
    </header>
    
    <main class="main-content">
        <div class="container">
            <section class="search-section">
                <h2>クリエイター検索</h2>
                <p class="section-description">noteクリエイターのIDを入力して、公開記事の分析データを取得します。</p>
                
                <form id="creator-search-form" class="search-form">
                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrfToken, ENT_QUOTES, 'UTF-8'); ?>">
                    <div class="form-group">
                        <label for="creator-id">クリエイターID</label>
                        <div class="input-group">
                            <input 
                                type="text" 
                                id="creator-id" 
                                name="creator_id" 
                                placeholder="例: note_official"
                                required
                            >
                            <button type="submit" class="btn btn-primary">検索</button>
                        </div>
                    </div>
                </form>
            </section>
            
            <section id="results-section" class="results-section" style="display: none;">
                <h2>分析結果</h2>
                
                <div id="loading" class="loading" style="display: none;">
                    <div class="spinner"></div>
                    <p>データを取得中...</p>
                </div>
                
                <div id="error-message" class="alert alert-error" style="display: none;"></div>
                
                <div id="creator-info" class="creator-info" style="display: none;">
                    <div class="creator-profile">
                        <img id="creator-avatar" src="" alt="アバター" class="creator-avatar">
                        <div class="creator-details">
                            <h3 id="creator-name"></h3>
                            <p id="creator-description"></p>
                        </div>
                    </div>
                </div>
                
                <div id="stats-section" class="stats-section" style="display: none;">
                    <h3>統計情報</h3>
                    <div class="stats-grid">
                        <div class="stat-card">
                            <span class="stat-label">総記事数</span>
                            <span id="total-articles" class="stat-value">-</span>
                        </div>
                        <div class="stat-card">
                            <span class="stat-label">総スキ数</span>
                            <span id="total-likes" class="stat-value">-</span>
                        </div>
                        <div class="stat-card">
                            <span class="stat-label">平均スキ数</span>
                            <span id="avg-likes" class="stat-value">-</span>
                        </div>
                    </div>
                </div>
                
                <div id="articles-section" class="articles-section" style="display: none;">
                    <h3>記事一覧</h3>
                    <div class="table-container">
                        <table class="articles-table">
                            <thead>
                                <tr>
                                    <th>タイトル</th>
                                    <th>スキ数</th>
                                    <th>公開日</th>
                                </tr>
                            </thead>
                            <tbody id="articles-tbody">
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
        </div>
    </main>
    
    <footer class="footer">
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> noteクリエイターダッシュボード</p>
            <p class="footer-note">※ 本ダッシュボードはnote APIの公開情報のみを利用しています。</p>
        </div>
    </footer>
    
    <script src="assets/js/app.js"></script>
</body>
</html>
