<?php
/**
 * ログインページ
 * noteクリエイター向けダッシュボード
 */

require_once __DIR__ . '/includes/auth.php';

// 既にログイン済みの場合はダッシュボードへリダイレクト
if (isLoggedIn()) {
    header('Location: index.php');
    exit;
}

$error = '';
$username = '';

// POSTリクエストの処理
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    $csrfToken = $_POST['csrf_token'] ?? '';
    
    // CSRFトークン検証
    if (!validateCsrfToken($csrfToken)) {
        $error = '不正なリクエストです。ページを再読み込みしてください。';
    } elseif (empty($username) || empty($password)) {
        $error = 'ユーザー名とパスワードを入力してください。';
    } else {
        $user = authenticateUser($username, $password);
        
        if ($user) {
            loginUser($user);
            header('Location: index.php');
            exit;
        } else {
            $error = 'ユーザー名またはパスワードが正しくありません。';
        }
    }
}

$csrfToken = generateCsrfToken();
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ログイン - noteクリエイターダッシュボード</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="login-page">
    <div class="login-container">
        <div class="login-box">
            <h1 class="login-title">noteクリエイターダッシュボード</h1>
            <p class="login-subtitle">ログインしてください</p>
            
            <?php if ($error): ?>
                <div class="alert alert-error">
                    <?php echo htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?>
                </div>
            <?php endif; ?>
            
            <form method="POST" action="login.php" class="login-form">
                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrfToken, ENT_QUOTES, 'UTF-8'); ?>">
                
                <div class="form-group">
                    <label for="username">ユーザー名</label>
                    <input 
                        type="text" 
                        id="username" 
                        name="username" 
                        value="<?php echo htmlspecialchars($username, ENT_QUOTES, 'UTF-8'); ?>"
                        required 
                        autocomplete="username"
                        autofocus
                    >
                </div>
                
                <div class="form-group">
                    <label for="password">パスワード</label>
                    <input 
                        type="password" 
                        id="password" 
                        name="password" 
                        required 
                        autocomplete="current-password"
                    >
                </div>
                
                <button type="submit" class="btn btn-primary btn-block">ログイン</button>
            </form>
        </div>
        
        <p class="login-footer">
            &copy; <?php echo date('Y'); ?> noteクリエイターダッシュボード
        </p>
    </div>
</body>
</html>
